# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Check if opponent's code is trivial (always C or always D)
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    current_round = len(my_history)
    
    # Final rounds: defect in rounds 9 and 10
    if current_round >= 8:
        return "D"
    
    # Check if opponent has defected in any previous round
    if any(move == "D" for move in opp_history):
        return "D"
    
    # Default: cooperate in early rounds
    return "C"